package editor;

import java.util.ArrayList;

public class HurtzoneLoadData {
	
	private int duration;
	private int timeBetweenFirings;
	private int damage;
	private int warmupTime;
	private int fireChanceNumerator;
	private int fireChanceDenominator;
	private double minColor;
	private double maxColor;
	private boolean isVertical;
	
	private ArrayList<HurtzonePointData> points;
	
	
	public HurtzoneLoadData(int theDuration,
							int theTimeBetweenFirings,
							int theDamage,
							int theWarmupTime,
							int theFireChanceNumerator,
							int theFireChanceDenominator,
							double theMinColor,
							double theMaxColor,
							boolean shouldBeVertical) {
		
		duration = theDuration;
		timeBetweenFirings = theTimeBetweenFirings;
		damage = theDamage;
		warmupTime = theWarmupTime;
		fireChanceNumerator = theFireChanceNumerator;
		fireChanceDenominator = theFireChanceDenominator;
		minColor = theMinColor;
		maxColor = theMaxColor;
		isVertical = shouldBeVertical;
		
		points = new ArrayList<HurtzonePointData>();
		
	}


	public int getDuration() {
		return duration;
	}


	public int getTimeBetweenFirings() {
		return timeBetweenFirings;
	}


	public int getDamage() {
		return damage;
	}


	public int getWarmupTime() {
		return warmupTime;
	}


	public int getFireChanceNumerator() {
		return fireChanceNumerator;
	}


	public int getFireChanceDenominator() {
		return fireChanceDenominator;
	}


	public double getMinColor() {
		return minColor;
	}


	public double getMaxColor() {
		return maxColor;
	}


	public boolean isVertical() {
		return isVertical;
	}
	
	
	public void add(HurtzonePointData point) {
		points.add(point);
	}
	
	public ArrayList<HurtzonePointData> getPoints() {
		return points;
	}
	
	
}
